"use strict";

class Trie {
	constructor(opt) {
		this.size = 0;
		this.root = {};
		this.opt = opt;
	}

	get length() {
		return this.size;
	}

	get _root() {
		return this.root;
	}

	__formatter(kw) {
		if (this.opt.ignore) kw = kw.toLowerCase();
		return kw;
	}

	insert(kw, mapped) {
		if (!kw) return false;
		if (!mapped) mapped = kw;

		kw = this.__formatter(kw);
		let node = this.root;
		for (const w of kw) {
			if (!node[w]) node[w] = {};
			node = node[w];
		}

		if (!node[KEYWORD]) {
			this.size++;
			node[KEYWORD] = mapped;
			return true;
		}

		return false;
	}

	del(kw) {
		if (kw) {
			const list = [];
			const node = this.traverse(kw, function(w, n){return list.push([w, n])});

			if (node && node[KEYWORD]) {
				//for (const [key2remove, pointer] of list.reverse()) {
				for (let val of list.reverse()) {
					key2remove = val[0]
					pointer = val[1]
					const len = Object.keys(pointer).length;
					if (len === 1) pointer[key2remove] = null;
					else {
						pointer[key2remove] = null;
						break;
					}
				}
				this.size--;
				return true;
			}
		}

		return false;
	}

	traverse(kw, cb) {
		if (!kw) return;
		kw = this.__formatter(kw);
		let node = this.root;
		for (const w of kw) {
			node = node[w];
			if (node) cb && cb(w, node);
			else return;
		}

		return node;
	}

	toMap(sofar, root) {
		if(sofar == null){
			sofar = ''
		}
		if(root == null){
			root = this.root;
		}
		let map = {};
		for (let k in root) {
			if (k === KEYWORD) map[sofar] = root[k];
			else {
				const sub = this.toMap(sofar + k, root[k]);
				for (let j in sub) map[j] = sub[j];
			}
		}

		return map;
	}

	get(kw) {
		let len = 0;
		const node = this.traverse(kw, function(){return len++});

		if (node && node[KEYWORD] && len === kw.length) return node[KEYWORD];
	}

	contains(kw) {
		let len = 0;
		const node = this.traverse(kw, function(){return len++});

		return node && node[KEYWORD] && len === kw.length;
	}

	clear() {
		this.size = 0;
		this.root = {};
	}
}



class FlashText {
	constructor(opt) {
		this.option = Object.assign({}, defaultOption, opt);
		this.trie = new Trie(this.option);
		this.boundaries = /[a-zA-Z0-9-]/g;
		this.whitespaceChars = new Set(['.', '\t', '\n', '\a', ' ', ',']);
	}

	get size() {
		return this.trie.length;
	}

	get _trie() {
		return this.trie;
	}

	setBoundaries(r) {
		if (r) this.boundaries = r;
		return this;
	}

	setWhiteSpaceChars(c) {
		if (Array.isArray(c) && c.length) this.whitespaceChars = new Set(c);
		return this;
	}

	addWhiteSpaceChars(c) {
		if (c) this.whitespaceChars.add(c);
		return this;
	}

	addKeyWord(keyword, mapped) {
		this.trie.insert(keyword, mapped);
	}

	addKeyWordsFromArray(keywords, mapped) {
		if (Array.isArray(keywords) && keywords.length)
			keywords.forEach(function(k){return this.addKeyWord(k, mapped)});
	}

	addKeyWordsFromObject(obj) {
		if(obj == null){
			obj = {}
		}
		//for (const [mapped, keywords] of Object.entries(obj))
		for (let val of Object.entries(obj)){
			mapped = val[0]
			keywords = val[1]
			this.addKeyWordsFromArray(keywords, mapped);
		}
	}

	removeKeyWord(keyword) {
		return this.trie.del(keyword);
	}

	removeKeyWordsFromArray(keywords) {
		if (Array.isArray(keywords) && keywords.length)
			keywords.forEach(function(k){return this.removeKeyWord(k)});
	}

	get(keyword) {
		return this.trie.get(keyword);
	}

	toMap() {
		return this.trie.toMap();
	}

	extractKeywords(sentence) {
		if (!sentence || typeof sentence !== 'string') return sentence;
		if (this.option.ignore) sentence = sentence.toLowerCase();

		const kws = [];
		let trie = this.trie._root;
		let end = 0;
		let i = 0;
		let len = sentence.length;

		while (i < len) {
			let char = sentence[i], sequenceFound;
			if (!this.boundaries.test(char)) {
				if (trie[KEYWORD] || trie[char]) {
					let longestSequenceFound, isLongerSequenceFound = false;
					// Find last
					if (trie[KEYWORD]) {
						sequenceFound = trie[KEYWORD];
						longestSequenceFound = trie[KEYWORD];
						end = i;
					}
					if (trie[char]) {
						let ii = i + 1;
						let continued = trie[char];

						while (ii < len) {
							let _char = sentence[ii];
							// Find last
							if (!this.boundaries.test(_char) && continued[KEYWORD]) {
								longestSequenceFound = continued[KEYWORD];
								end = ii;
								isLongerSequenceFound = true;
							}

							if (continued[_char]) {
								continued = continued[_char];
							}
							else break;
							++ii;
						}

						if (ii >= len && continued[KEYWORD]) {
							longestSequenceFound = continued[KEYWORD];
							end = ii;
							isLongerSequenceFound = true;
						}

						if (isLongerSequenceFound) {
							i = end;
						}
					}

					trie = this.trie._root;

					if (longestSequenceFound) {
						kws.push(longestSequenceFound);
					}
				}
				else {
					trie = this.trie._root;
				}
			}
			else if (trie[char]) {
				trie = trie[char];
			}
			else {
				trie = this.trie._root;
				let ii = i + 1;
				while (ii < len) {
					char = sentence[ii];
					if (!this.boundaries.test(char)) break;
					++ii;
				}
				i = ii;
			}

			if (i + 1 >= len && trie[KEYWORD]) {
				sequenceFound = trie[KEYWORD];
				kws.push(sequenceFound);
			}
			++i;
		}

		return kws;
	}
	isAlpha(char) {
		return /^[A-Za-z]$/.test(char);
	}

	replaceKeyWords(sentence) {
		if (!sentence || typeof sentence !== 'string') return sentence;
		let newSentence = [];
		let originalSentence = sentence;
		if (this.option.ignore) sentence = sentence.toLowerCase();
		let currentWord = '';
		let trie = this.trie._root;
		let currentWhiteSpace = '';
		let end = 0;
		let idx = 0;
		let len = sentence.length;

		while (idx < len) {
			let char = sentence[idx];
			currentWord += originalSentence[idx];

			let sequenceFound, longestSequenceFound, isLongerSequenceFound, idy;
			if (!this.boundaries.test(char)) {
				currentWhiteSpace = char;
				if (trie[KEYWORD] || trie[char]) {

					if (trie[KEYWORD]) {
						sequenceFound = longestSequenceFound = trie[KEYWORD];
						end = idx;
					}

					if (trie[char]) {
						let trieContinue = trie[char];
						let wordContinue = currentWord;
						idy = idx + 1;
						while (idy < len) {
							let _char = sentence[idy];
							wordContinue += originalSentence[idy];
							if (!this.boundaries.test(_char) && trieContinue[KEYWORD] && ((idx - 1 < 0 || !this.isAlpha(sentence[idx - 1])) || !this.isAlpha(sentence[idx])) && (!this.isAlpha(sentence[idy]) || !this.isAlpha(sentence[idy - 1]))) {
								currentWhiteSpace = _char;
								longestSequenceFound = trieContinue[KEYWORD];
								end = idy;
								isLongerSequenceFound = 1;
							}
							if (trieContinue[_char]) {
								trieContinue = trieContinue[_char];
							}
							else break;

							idy++;
						}

						if (idy >= len && trieContinue[KEYWORD]) {
							if (idy == len && idx - 1 > 0 && ((this.isAlpha(sentence[idx - 1])))) {
								// ??
							} else {

								currentWhiteSpace = '';
								longestSequenceFound = trieContinue[KEYWORD];
								end = idy;
								isLongerSequenceFound = 1;
							}
						}

						if (isLongerSequenceFound) {
							idx = end;
							currentWord = wordContinue;
						}
					}

					trie = this.trie._root;

					if (longestSequenceFound) {
						newSentence.push(longestSequenceFound + currentWhiteSpace);
						currentWord = '';
						currentWhiteSpace = '';
					}
					else {
						newSentence.push(currentWord);
						currentWord = '';
						currentWhiteSpace = '';
					}
				}
				else {
					trie = this.trie._root;
					newSentence.push(currentWord);
					currentWord = '';
					currentWhiteSpace = '';
				}
			}
			else if (trie[char]) {
				trie = trie[char];
			}
			else {
				trie = this.trie._root;
				idy = idx + 1;
				while (idy < len) {
					let _char = sentence[idy];
					currentWord += originalSentence[idy];
					if (!this.boundaries.test(_char)) break;
					idy++;
				}
				idx = idy;
				newSentence.push(currentWord);
				currentWord = '';
				currentWhiteSpace = '';
			}

			if (idx + 1 >= len) {
				if (trie[KEYWORD]) {
					sequenceFound = trie[KEYWORD];
					newSentence.push(sequenceFound);
				}
				else {
					newSentence.push(currentWord);
				}
			}
			idx++;
		}

		return newSentence.join('');
	}

	clear() {
		this.trie.clear();
	}
}

const defaultOption = {
	ignore: false,
};

var KEYWORD = '__FlashText.js__';

var xhr = new XMLHttpRequest();
xhr.open('GET', 'data/translate.json', false);
xhr.send(null);
let translate_data = JSON.parse(xhr.responseText);
var key_processor = new FlashText()
key_processor.setBoundaries(/[ñÑáéíóúÉÓÚàâäãèêëïîìôöòõùûüÿçÂÀÃÈÊËÎÌÔÛÙÜŸÇÒÕ]/g);
for (let key in translate_data) {
	key_processor.addKeyWord(key, translate_data[key]);
}
function nextEventCode(game, index) {
	var command = game._list[index + 1];
	if (command) {
		return command.code;
	} else {
		return 0;
	}
}

Window_Base.prototype._drawText = Window_Base.prototype.drawText;

Window_Base.prototype.drawText = function () {
	let text = arguments[0]
	if (text) {
		console.log(text)
		arguments[0] = key_processor.replaceKeyWords(text);

	}
	return Window_Base.prototype._drawText.apply(this, arguments);
}

Game_Message.prototype._add = Game_Message.prototype.add;
Game_Message.prototype.add = function () {
	let text = arguments[0]
	if (text) {
	/*	let regex = /\\v\[(\d+)\]/g;
		let match;
		while ((match = regex.exec(text)) !== null) {
			let id = parseInt(match[1]);
			let str = $gameVariables.value(id);
			if (typeof str === 'string') {
				console.log(str)
				$gameVariables.setValue(id, key_processor.replaceKeyWords(str));
			}
		}
		*/
		
		arguments[0] = key_processor.replaceKeyWords(text);

	}
	return Game_Message.prototype._add.apply(this, arguments);
}
if(typeof Window_MapActiveQuest !== 'undefined'){
	Window_MapActiveQuest.prototype._drawQuestTextEx = Window_MapActiveQuest.prototype.drawQuestTextEx;

	Window_MapActiveQuest.prototype.drawQuestTextEx = function () {
		let text = arguments[0]
		if (text) {
			console.log(text)
			arguments[0] = key_processor.replaceKeyWords(text);

		}
		return Window_MapActiveQuest.prototype._drawQuestTextEx.apply(this, arguments);
	}
}
if (typeof Window_QuestData !== 'undefined') {
	Window_QuestData.prototype._drawQuestTextEx = Window_QuestData.prototype.drawQuestTextEx;

	Window_QuestData.prototype.drawQuestTextEx = function () {
		let text = arguments[0]
		if (text) {
			console.log(text)
			arguments[0] = key_processor.replaceKeyWords(text);

		}
		return Window_QuestData.prototype._drawQuestTextEx.apply(this, arguments);
	}
}
Window_Base.prototype._processCharacter = Window_Base.prototype.processCharacter;

Window_Base.prototype.processCharacter = function () {
	let textState = arguments[0];
	if (textState.hasOwnProperty("text")) {

		arguments[0].text = key_processor.replaceKeyWords(arguments[0].text);
	}
	return Window_Base.prototype._processCharacter.apply(this, arguments);

}
Window_ChoiceList.prototype._textWidthEx = Window_ChoiceList.prototype.textWidthEx;
 

Window_ChoiceList.prototype.textWidthEx = function () {
	let text = arguments[0]
	console.log(text)
	if (text && new Error().stack.indexOf("Window_QuestData.drawQuestTextEx") == -1) {
		

		arguments[0] = key_processor.replaceKeyWords(text);

	}
	return Window_ChoiceList.prototype._textWidthEx.apply(this, arguments);
}
Window_Base.prototype._drawTextEx = Window_Base.prototype.drawTextEx;

Window_Base.prototype.drawTextEx = function () {
	let text = arguments[0]
	if (text && new Error().stack.indexOf("Window_QuestData.drawQuestTextEx") == -1) {
		let regex = /\\v\[(\d+)\]/g;
		let match;
		while ((match = regex.exec(text)) !== null) {
			let id = parseInt(match[1]);
			let str = $gameVariables.value(id);
			if (typeof str === 'string') {
				console.log(str)
				$gameVariables.setValue(id, key_processor.replaceKeyWords(str));
			}
		}
		
		arguments[0] = key_processor.replaceKeyWords(text);

	}
	return Window_Base.prototype._drawTextEx.apply(this, arguments);
}
Game_Interpreter.prototype._command101 = Game_Interpreter.prototype.command101;
Game_Interpreter.prototype.command101 = function () {
	let idx = this._index;
	if (!$gameMessage.isBusy()) {

		while (nextEventCode(this, idx) === 401) {  // Text data
			idx++;
			console.log(this._list[idx].parameters[0])
			this._list[idx].parameters[0] = key_processor.replaceKeyWords(this._list[idx].parameters[0]);
		}
	}
	if (nextEventCode(this, idx) == 102) {
		idx++;
		if (this._list[idx].parameters) {
			for (let i = 0; i < this._list[idx].parameters[0].length; i++) {
				console.log(this._list[idx].parameters[0][i])
				this._list[idx].parameters[0][i] = key_processor.replaceKeyWords(this._list[idx].parameters[0][i]);
			}
		}
	}
	return Game_Interpreter.prototype._command101.call(this);
}





////////////////////////////// The Genesis Order patcher SCRIPT //////////////////////////////

Game_Variables.prototype._setValue = Game_Variables.prototype.setValue 
Game_Variables.prototype.setValue = function(id,value){
	if(id == 21){
		arguments[1] =  key_processor.replaceKeyWords(value)
	}
	return Game_Variables.prototype._setValue.apply(this, arguments);	
}

////////////////////////////// OrangeHud SCRIPT //////////////////////////////

if (typeof OrangeHudDefaultLine !== 'undefined') {
    OrangeHudDefaultLine._drawLine = OrangeHudDefaultLine.drawLine;

    OrangeHudDefaultLine.drawLine = function() {
        let variableData = arguments[1];

        if (variableData.hasOwnProperty("Pattern")) {
            arguments[1].Pattern = key_processor.replaceKeyWords(arguments[1].Pattern);
        }
        return OrangeHudDefaultLine._drawLine.apply(this, arguments);
    }
}